/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdarg.h>

#include "lx.h"
#include "lx_map_file.h"

lx_t lx [2];

static void usage (char*s)
{
  fprintf (stderr, "usage: %s <original map file> <current map file>\n", s);
  exit (0);
}

static int read_map (char*s, lx_t*lx, lx_map_t*m)
{
  FILE*fp;
  lx_node_t*first;
  
  if (!(fp = fopen (s, "r")))
  {
    fprintf (stderr, "couldn't open %s\n", s);
    return 0;
  }
  
  if (!lx_map_file_read (fp, m, &first))
  {
    fprintf (stderr, "lx_map_file_read () failed on %s\n", s);
    return 0;
  }
  fprintf (stderr, "%d hosts and %d xbars\n", m->num_hosts, m->num_xbars);
  return 1;
}

int main (int argc, char*argv [])
{
  int i, xbars_found;
  lx_node_t*higher;  
  lx_queue_t q;
  lx_node_t*n1, *nn1;
  lx_node_t*h2, *n2, *nn2;
  lx_map_t*m1, *m2;
  int iport = 0;
  
  mi_verbose_flag = 0;
  
  if (argc < 3)
    usage (argv [0]);
  
  for (i = 0; i < 2; i++)
  {
    lx_init (&lx [i]);
    if (!read_map (argv [i + 1], &lx [i], &lx [i].maps [0]))
      usage (argv [0]);
  }
  
  m1 = &lx [0].maps [0];
  m2 = &lx [1].maps [0];
  
  for (i = 0; i < m1->num_hosts; i++)
    if ((h2 = lx_find_host (lx, &m2->hosts, lx_host_c (m1->host_array [i])->mac_address, 0, &higher)))
      break;
    
  if (i == m1->num_hosts)
  {
    printf ("no common hosts\n");
    return 0;
  }

  n1 = lx_get_node (m1->host_array [i], iport);
  
  if (!n1 || !n1->xbar)
  {
    printf ("not connected to an xbar\n");
    return 0;
  }
  n1->original.port = lx_get_port (m1->host_array [i], iport);
  
  n2 = lx_get_node (h2, iport);
  
  if (!n2 || !n2->xbar)
  {
    printf ("not connected to an xbar\n");
    return 0;
  }

  n1->original.index = n2;
  n2->original.port = lx_get_port (h2, iport);

  printf (lx_node_format " matches " lx_node_format "\n", lx_node_args (n1), lx_node_args (n2));

  xbars_found = 0;
  
  for (i = 0; i < m1->num_xbars; i++)
    lx_xbar_c (m1->xbar_array [i])->level = 0;
  
  lx_bzero ((char*) &q, sizeof (q));
  
  lx_put (&q, lx_remove (&m1->xbars, n1));
  lx_xbar_c (n1)->level = 1;
  
  while ((n1 = lx_get (&q)))
  {
    lx_put (&m1->xbars, n1);

    n2 = n1->original.index;
    insist (n2)
    
    for (i = 0; i < LX_XBAR_SIZE; i++)
    { 
      mi_punt (m->lx);
      if ((nn1 = lx_get_node (n1, i + n1->first)))
      {
	if (nn1->xbar)
	{
	  if (!lx_xbar_c (nn1)->level)
	  {
	    nn2 = lx_get_node (n2, i + n2->first + n1->original.port - n2->original.port);
	    nn1->original.index = nn2;
	    nn1->original.port = lx_get_port (n1, i + n1->first);
	    if (nn2)
	    {
	      nn2->original.port = lx_get_port (n2, i + n2->first + n1->original.port - n2->original.port);
	      printf (lx_node_format " matches " lx_node_format "\n", lx_node_args (nn1), lx_node_args (nn2));
	    
	      lx_xbar_c (nn1)->level = 1;
	      lx_put (&q, lx_remove (&m1->xbars, nn1));
	    }
	    else
	    {
	      printf (lx_node_format " unmatched port %d\n", lx_node_args (n1), i + n1->first);
	    }
	  }
	}
      }
    }
  }
  insist (!q.count);
  return 1;
  except: return 0;
}
